<?php include('includes/header.php'); ?>
<?php include('db.php'); ?>


<!-- PAGE HEADER / BREADCRUMB -->
<section class="page-header">
  <div class="page-header__bg" style="background-image: url('https://images.unsplash.com/photo-1563714193017-5a5fb60bc02b?q=80&w=687&auto=format&fit=crop&ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D')"></div>
  <div class="container">
    <ul class="wallpi-breadcrumb list-unstyled d-flex flex-wrap justify-content-center mb-2">
      <li><a href="index.php" class="text-decoration-none text-success">Home</a></li>
      <li><span class="text-muted ms-2">About</span></li>
    </ul>
    <h2 class="page-header__title text-dark">About Us</h2>
  </div>
</section>
<style>
  .page-header {
  position: relative;
  padding: 100px 0;
  text-align: center;
  overflow: hidden;
  background-color: #f3f3f3;
}

.page-header__bg {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background-size: cover;
  background-position: center;
  opacity: 0.25;
  z-index: 1;
}

.page-header .container {
  position: relative;
  z-index: 2;
}

.page-header__title {
  font-size: 40px;
  font-weight: bold;
  color: #212529;
}

</style>


<!-- HERO SECTION -->
<section class="py-5 bg-light">
  <div class="container d-flex flex-wrap align-items-center">
    <div class="col-md-6 mb-4">
      <h6 class="text-success">CARE FEATURES</h6>
      <h1 class="fw-bold text-dark">We want to help you<br>to grow plant.</h1>
      <p class="text-muted">We take pride in customizing our services to meet the needs and budgets of each individual customer. This may seem simple, but we believe in investing in every aspect of our business-to-customer relationship.</p>
      <div class="d-flex align-items-center mt-3">
        <a href="contact.php" class="btn btn-success me-3">Start A Project →</a>
        <div class="d-flex align-items-center">
          <div class="bg-success text-white rounded-circle p-2 me-2">
            <i class="fas fa-phone"></i>
          </div>
          <div>
            <strong>Need help?</strong><br>
            <span>+1 310 500 7834</span>
          </div>
        </div>
      </div>
    </div>
    <div class="col-md-6 text-center">
      <img src="https://plus.unsplash.com/premium_photo-1663040596061-8ec3c6048641?q=80&w=2070&auto=format&fit=crop&ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D" alt="Garden Path" class="img-fluid rounded">
    </div>
  </div>
</section>

<!-- STATISTICS - DYNAMIC COUNTERS -->
<section class="py-5 text-center bg-white">
  <div class="container">
    <div class="row">
      <div class="col-md-3 col-6 mb-4">
        <h3 class="text-dark counter" data-target="100">0</h3>
        <p class="text-muted">Certificates & Awards</p>
      </div>
      <div class="col-md-3 col-6 mb-4">
        <h3 class="text-dark counter" data-target="48000">0</h3>
        <p class="text-muted">Expert Landscapers</p>
      </div>
      <div class="col-md-3 col-6 mb-4">
        <h3 class="text-dark counter" data-target="62000">0</h3>
        <p class="text-muted">Completed Projects</p>
      </div>
      <div class="col-md-3 col-6 mb-4">
        <h3 class="text-dark counter" data-target="977000">0</h3>
        <p class="text-muted">Happy Customers</p>
      </div>
    </div>
  </div>
</section>

<!-- ABOUT & MISSION -->
<section class="py-5 bg-light">
  <div class="container">
    <h2 class="text-success mb-4">About Us</h2>
    <p>Global Gardenia is your eco-conscious partner in all things green. We believe in creating sustainable and beautiful spaces by offering a range of biodegradable and environmentally friendly gardening products. Whether you’re looking to enhance your home garden or start a green revolution, our products are curated with love for the Earth and passion for plants.</p>
    <p>Founded by nature lovers, Global Gardenia has grown into a trusted brand offering not only products but also education and support for a greener future. Our mission is to bring nature back into people's lives—one eco-product at a time.</p>
    <div class="row mt-4">
      <div class="col-md-6">
        <h5 class="text-success">Our Vision</h5>
        <p>To be the most trusted brand in sustainable gardening and eco-living.</p>
      </div>
      <div class="col-md-6">
        <h5 class="text-success">Our Mission</h5>
        <p>To deliver high-quality, affordable eco-products while inspiring and educating communities to grow green.</p>
      </div>
    </div>
  </div>
</section>

<!-- CLIENT TESTIMONIAL -->
<section class="py-5 text-center">
  <div class="container">
    <h6 class="text-success">CARE FEATURES</h6>
    <h2 class="fw-bold">What Client say?</h2>
    <div class="my-3">
      <i class="fas fa-star text-warning"></i>
      <i class="fas fa-star text-warning"></i>
      <i class="fas fa-star text-warning"></i>
      <i class="fas fa-star text-warning"></i>
      <i class="fas fa-star text-warning"></i>
    </div>
    <p class="text-muted w-75 mx-auto">We are a gated golf course community, comprised of 1137 homes, located in Broward County, Florida. Garden Services has been our landscape contractor for over 11 years. All of their work meets or exceeds our expectations.</p>
  </div>
</section>

<!-- CONTACT FORM -->
<section class="py-5 bg-light">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-md-6">
        <h4 class="text-success">Quick Estimate</h4>
        <h2 class="fw-bold">Get a Free Quote Today</h2>
        <img src="https://plus.unsplash.com/premium_photo-1723867395295-81316a1778fc?q=80&w=2043&auto=format&fit=crop&ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D;" alt="House with Garden" class="img-fluid rounded mt-3">
      </div>
      <div class="col-md-6">
        <form>
          <div class="mb-3">
            <input type="text" class="form-control" placeholder="Your Name">
          </div>
          <div class="mb-3">
            <input type="email" class="form-control" placeholder="Your Email">
          </div>
          <div class="mb-3">
            <textarea class="form-control" rows="4" placeholder="Write Message"></textarea>
          </div>
          <button type="submit" class="btn btn-success">Send Message</button>
        </form>
      </div>
    </div>
  </div>
</section>

<!-- COUNTER SCRIPT -->
<script>
  const counters = document.querySelectorAll('.counter');
  const speed = 200; // lower = faster

  counters.forEach(counter => {
    const updateCount = () => {
      const target = +counter.getAttribute('data-target');
      const count = +counter.innerText;

      const inc = Math.max(1, target / speed);

      if (count < target) {
        counter.innerText = Math.ceil(count + inc);
        setTimeout(updateCount, 10);
      } else {
        counter.innerText = target.toLocaleString();
      }
    };

    const observer = new IntersectionObserver(entries => {
      entries.forEach(entry => {
        if (entry.isIntersecting) {
          updateCount();
          observer.unobserve(entry.target);
        }
      });
    }, { threshold: 1.0 });

    observer.observe(counter);
  });
</script>

<?php include('includes/footer.php'); ?>
