<?php
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Admin Panel</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    body {
      background-color: #f4f6f9;
    }
    .sidebar {
      height: 100vh;
      background-color: #212529;
      color: #fff;
      padding: 20px 0;
    }
    .sidebar a {
      color: #adb5bd;
      text-decoration: none;
      padding: 10px 20px;
      display: block;
    }
    .sidebar a:hover {
      background-color: #343a40;
      color: #fff;
    }
    .header {
      background-color: #fff;
      padding: 20px;
      box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
    .card {
      border: none;
      border-radius: 0.5rem;
      box-shadow: 0 4px 10px rgba(0, 0, 0, 0.05);
    }
  </style>
</head>
<body>
  <div class="container-fluid">
    <div class="row">
      <!-- Sidebar -->
      <div class="col-md-2 sidebar">
        <h4 class="text-center">Admin</h4>
        <a href="#"><i class="fas fa-home me-2"></i> Dashboard</a>
        <a href="product/list.php"><i class="fas fa-boxes me-2"></i> Products</a>
        <a href="#"><i class="fas fa-users me-2"></i> Users</a>
        <a href="#"><i class="fas fa-chart-line me-2"></i> Reports</a>
        <a href="#"><i class="fas fa-cog me-2"></i> Blog</a>
        <a href="logout.php"><i class="fas fa-sign-out-alt me-2"></i> Logout</a>
      </div>

      <!-- Main content -->
      <div class="col-md-10">
        <div class="header mb-4">
          <h3>Welcome to Hritik's Admin Panel</h3>
          <!-- <a href="logout.php" class="btn btn-danger">Logout</a> -->
        </div>

        <div class="row g-4">
          <div class="col-md-3">
            <div class="card text-white bg-success">
              <div class="card-body">
                <h5 class="card-title">Total Products</h5>
                <p class="card-text fs-4">150</p>
              </div>
            </div>
          </div>
          <div class="col-md-3">
            <div class="card text-white bg-primary">
              <div class="card-body">
                <h5 class="card-title">Total Users</h5>
                <p class="card-text fs-4">1,245</p>
              </div>
            </div>
          </div>
          <div class="col-md-3">
            <div class="card text-white bg-warning">
              <div class="card-body">
                <h5 class="card-title">Sales</h5>
                <p class="card-text fs-4">$34K</p>
              </div>
            </div>
          </div>
          <div class="col-md-3">
            <div class="card text-white bg-danger">
              <div class="card-body">
                <h5 class="card-title">Pending Orders</h5>
                <p class="card-text fs-4">24</p>
              </div>
            </div>
          </div>
        </div>

        <div class="mt-5">
          <h4>Recent Activities</h4>
          <table class="table table-bordered mt-3">
            <thead class="table-light">
              <tr>
                <th>#</th>
                <th>Activity</th>
                <th>Time</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>1</td>
                <td>New user registered</td>
                <td>5 mins ago</td>
              </tr>
              <tr>
                <td>2</td>
                <td>Product "Eco Pot" added</td>
                <td>20 mins ago</td>
              </tr>
              <tr>
                <td>3</td>
                <td>Order #1234 processed</td>
                <td>1 hour ago</td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
