<?php
session_start();
if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
    header("Location: index.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Cyberpunk Admin Login</title>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/three.js/r128/three.min.js"></script>
  <style>
    *{margin:0;padding:0;box-sizing:border-box;}
    body,html{width:100%;height:100%;overflow:hidden;font-family:'Orbitron',sans-serif;background:#000;}

    canvas{position:fixed;top:0;left:0;z-index:-1;}

    .login-box{
      position:absolute;
      top:50%;left:50%;
      transform:translate(-50%,-50%);
      width:380px;
      padding:40px;
      border-radius:15px;
      background:rgba(0,0,0,0.6);
      border:2px solid #0ff;
      box-shadow:0 0 30px #0ff;
      color:#0ff;
      text-align:center;
      backdrop-filter: blur(15px);
    }

    .login-box h2{
      margin-bottom:20px;
      font-size:28px;
      text-shadow:0 0 15px #0ff;
    }

    .login-box input{
      width:100%;
      padding:12px 15px;
      margin:12px 0;
      border:none;
      border-radius:8px;
      font-size:16px;
      outline:none;
      background:rgba(0,255,255,0.1);
      color:#0ff;
      border:1px solid #0ff;
      box-shadow:0 0 10px #0ff;
      transition:0.3s;
    }
    .login-box input:focus{
      background:rgba(0,255,255,0.3);
      box-shadow:0 0 20px #0ff;
      transform:scale(1.05);
    }

    .btn-login{
      width:100%;
      padding:12px;
      margin-top:15px;
      border:none;
      border-radius:8px;
      font-size:18px;
      font-weight:bold;
      cursor:pointer;
      background:linear-gradient(90deg,#0ff,#06f);
      color:#fff;
      box-shadow:0 0 20px #0ff;
      transition:0.3s;
    }
    .btn-login:hover{
      box-shadow:0 0 30px #0ff, 0 0 50px #06f;
      transform:scale(1.05);
    }
  </style>
</head>
<body>
  <div class="login-box">
    <h2>🔐 Admin Login</h2>
    <form action="login-check.php" method="POST">
      <input type="text" name="username" placeholder="👤 Username" required>
      <input type="password" name="password" placeholder="🔒 Password" required>
      <button type="submit" class="btn-login">LOGIN</button>
    </form>
  </div>

  <script>
    // Neon grid background
    let scene = new THREE.Scene();
    let camera = new THREE.PerspectiveCamera(75, window.innerWidth/window.innerHeight, 0.1, 1000);
    let renderer = new THREE.WebGLRenderer({antialias:true});
    renderer.setSize(window.innerWidth, window.innerHeight);
    document.body.appendChild(renderer.domElement);

    let gridHelper = new THREE.GridHelper(200, 40, 0x00ffff, 0x00ffff);
    gridHelper.material.opacity = 0.2;
    gridHelper.material.transparent = true;
    scene.add(gridHelper);

    let cubeGeometry = new THREE.TorusKnotGeometry(2, 0.6, 100, 16);
    let cubeMaterial = new THREE.MeshStandardMaterial({
      color:0x00ffff,
      emissive:0x0099ff,
      metalness:0.8,
      roughness:0.2
    });
    let cube = new THREE.Mesh(cubeGeometry, cubeMaterial);
    cube.position.set(0,3,-10);
    scene.add(cube);

    let light = new THREE.PointLight(0x00ffff, 2, 100);
    light.position.set(10,10,10);
    scene.add(light);

    camera.position.y = 5;
    camera.position.z = 20;

    function animate(){
      requestAnimationFrame(animate);
      cube.rotation.x += 0.01;
      cube.rotation.y += 0.01;
      gridHelper.rotation.z += 0.001;
      renderer.render(scene,camera);
    }
    animate();

    window.addEventListener('resize',()=>{
      camera.aspect = window.innerWidth/window.innerHeight;
      camera.updateProjectionMatrix();
      renderer.setSize(window.innerWidth,window.innerHeight);
    });
  </script>
</body>
</html>
