<?php
include '../../db.php';
$id = $_GET['id'];
$product = $conn->query("SELECT * FROM products WHERE id = $id")->fetch_assoc();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $category_id = $_POST['category_id'];
    $product_name = $_POST['product_name'];
    $description = $_POST['description'];
    $price = $_POST['price'];
    $slug = strtolower(str_replace(' ', '-', $product_name));

    // Update image only if new one is uploaded
    if ($_FILES['product_image']['name']) {
        $image_name = time() . "_" . basename($_FILES["product_image"]["name"]);
        $target_file = "../../uploads/" . $image_name;
        move_uploaded_file($_FILES["product_image"]["tmp_name"], $target_file);
        $image_path = "uploads/" . $image_name;
    } else {
        $image_path = $product['product_image'];
    }

    $stmt = $conn->prepare("UPDATE products SET category_id=?, product_name=?, product_image=?, description=?, price=?, slug=? WHERE id=?");
    $stmt->bind_param("isssdsi", $category_id, $product_name, $image_path, $description, $price, $slug, $id);
    $stmt->execute();

    header("Location: list.php?msg=Product updated");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Edit Product</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-5 bg-light">
<div class="container bg-white p-4 rounded shadow">
  <h2 class="mb-4">✏️ Edit Product</h2>
  <form method="POST" enctype="multipart/form-data">
    <div class="mb-3">
      <label>Category</label>
      <select name="category_id" class="form-select" required>
        <option value="">Select Category</option>
        <?php
        $res = $conn->query("SELECT * FROM product_categories");
        while ($cat = $res->fetch_assoc()) {
            $selected = $cat['id'] == $product['category_id'] ? "selected" : "";
            echo "<option value='{$cat['id']}' $selected>{$cat['category_name']}</option>";
        }
        ?>
      </select>
    </div>
    <div class="mb-3">
      <label>Product Name</label>
      <input type="text" name="product_name" value="<?= htmlspecialchars($product['product_name']) ?>" class="form-control" required>
    </div>
    <div class="mb-3">
      <label>Image (leave empty to keep existing)</label>
      <input type="file" name="product_image" class="form-control">
      <img src="../../<?= $product['product_image'] ?>" width="100" class="mt-2">
    </div>
    <div class="mb-3">
      <label>Description</label>
      <textarea name="description" class="form-control"><?= htmlspecialchars($product['description']) ?></textarea>
    </div>
    <div class="mb-3">
      <label>Price (₹)</label>
      <input type="text" name="price" value="<?= $product['price'] ?>" class="form-control" required>
    </div>
    <button type="submit" class="btn btn-success">Update Product</button>
    <a href="list.php" class="btn btn-secondary">Cancel</a>
  </form>
</div>
</body>
</html>
