<?php include('admin/db.php'); ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <title>Blog | Mahajan Eye Center</title>
    <meta name="description" content="Explore expert blogs on LASIK, Cataract Surgery, and Vision Care at Mahajan Eye Centre in Delhi.">
    <link rel="canonical" href="https://www.mahajaneyecentre.com/blog.php" />
    <?php include('include/head.php'); ?>
    <style>
        .blog-card {
            display: flex;
            flex-direction: column;
            border-radius: 16px;
            box-shadow: 0 4px 16px rgba(0,0,0,0.1);
            margin-bottom: 30px;
            transition: transform 0.3s ease;
            height: 100%;
        }
        .blog-card:hover {
            transform: translateY(-5px);
        }
        .blog-img {
            height: 200px;
            object-fit: cover;
            border-top-left-radius: 16px;
            border-top-right-radius: 16px;
        }
        .card-body {
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            padding: 1.25rem;
        }
        .blog-title {
            font-size: 2rem;
            font-weight: 700;
            color: #007bff;
            text-align: center;
            margin-bottom: 2rem;
        }
        @media (max-width: 767px) {
            .blog-title {
                font-size: 1.5rem;
            }
        }
    </style>
</head>
<body>
<?php include('include/header.php'); ?>

<!-- Page Title -->
<section class="page-title-section bg-img cover-background left-overlay-secondary" data-overlay-dark="8" data-background="img/banner/blog.jpg">
    <div class="container">
        <div class="page-title">
            <h1>Blog</h1>
            <ul>
                <li><a href="/" class="text-white">Home</a></li>
                <li><span class="text-white">Blog</span></li>
            </ul>
        </div>
    </div>
</section>

<!-- Blog Grid -->
<section class="py-5">
    <div class="container">
        <h2 class="blog-title">📰 Latest Blogs</h2>
        <div class="row">
            <?php
            $sql = "SELECT id, title, slug, image, content, created_at FROM blogs WHERE status = 1 ORDER BY created_at DESC";
            $result = $conn->query($sql);

            if ($result->num_rows > 0):
                while($row = $result->fetch_assoc()):
            ?>
            <div class="col-md-6 col-lg-4 mb-4 d-flex">
                <div class="card blog-card w-100">
                    <?php if ($row['image']): ?>
                        <img src="admin/blogs/uploads/<?= htmlspecialchars($row['image']) ?>" class="card-img-top blog-img" alt="<?= htmlspecialchars($row['title']) ?>">
                    <?php endif; ?>
                    <div class="card-body">
                        <div>
                            <h5 class="card-title"><?= htmlspecialchars($row['title']) ?></h5>
                            <p class="card-text"><?= substr(strip_tags($row['content']), 0, 100) ?>...</p>
                        </div>
                        <a href="blog-detail.php?slug=<?= urlencode($row['slug']) ?>" class="btn btn-outline-primary mt-3 text-dark ">Read More →</a>
                    </div>
                </div>
            </div>
            <?php endwhile; else: ?>
                <p class="text-center col-12">No blogs found.</p>
            <?php endif; ?>
        </div>
    </div>
</section>

<?php include('include/footer.php'); ?>
</body>
</html>