<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

$host = 'localhost';
$user = 'root';
$pass = 'root';
$db = 'globalgardenia';

$conn = new mysqli($host, $user, $pass, $db);

if ($conn->connect_error) {
    die('❌ Database connection failed: ' . $conn->connect_error);
}

include 'includes/header.php';

$slug = $_GET['slug'] ?? '';
if (empty($slug)) {
    echo "<div class='container py-5'><div class='alert alert-danger'>Invalid category.</div></div>";
    include 'includes/footer.php';
    exit;
}

$stmt = $conn->prepare("SELECT * FROM product_categories WHERE slug = ?");
$stmt->bind_param("s", $slug);
$stmt->execute();
$category = $stmt->get_result()->fetch_assoc();

if (!$category) {
    echo "<div class='container py-5'><div class='alert alert-warning'>Category not found.</div></div>";
    include 'includes/footer.php';
    exit;
}

$cat_id = $category['id'];
$stmt2 = $conn->prepare("SELECT * FROM products WHERE category_id = ?");
$stmt2->bind_param("i", $cat_id);
$stmt2->execute();
$products = $stmt2->get_result();
?>

<section class="page-header">
  <div class="page-header__bg" style="background-image: url('https://images.unsplash.com/photo-1563714193017-5a5fb60bc02b?q=80&w=687&auto=format&fit=crop&ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D')"></div>
  <div class="container">
    <ul class="wallpi-breadcrumb list-unstyled d-flex flex-wrap justify-content-center mb-2">
      <li><a href="index.php" class="text-decoration-none text-success">Home</a></li>
      <li><span class="text-muted ms-2">/ Products</span></li>
    </ul>
    <h2 class="page-header__title text-dark">Products</h2>
  </div>
</section>
<style>
  .page-header {
  position: relative;
  padding: 100px 0;
  text-align: center;
  overflow: hidden;
  background-color: #f3f3f3;
}

.page-header__bg {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background-size: cover;
  background-position: center;
  opacity: 0.25;
  z-index: 1;
}

.page-header .container {
  position: relative;
  z-index: 2;
}

.page-header__title {
  font-size: 40px;
  font-weight: bold;
  color: #212529;
}

</style>

<section class="py-5">
  <div class="container">
    <h2 class="mb-4 text-success"><?= htmlspecialchars($category['category_name']) ?> Products</h2>
    <div class="row">
      <?php if ($products->num_rows > 0): ?>
        <?php while($row = $products->fetch_assoc()): ?>
          <div class="col-md-4 mb-4">
            <div class="card h-100 shadow-sm border-0 rounded-4">
              <img src="<?= htmlspecialchars($row['product_image']) ?>" class="card-img-top" alt="<?= htmlspecialchars($row['product_name']) ?>" style="height: 250px; object-fit: cover;">
              <div class="card-body d-flex flex-column">
                <h5 class="card-title"><?= htmlspecialchars($row['product_name']) ?></h5>
                <p class="card-text"><?= htmlspecialchars($row['description']) ?></p>
                <p class="card-text fw-bold text-success">Price: ₹<?= number_format($row['price'], 2) ?></p>
                <div class="mt-auto">
                  <!-- <a href="cart.php?product_id=<?= $row['id'] ?>" class="btn btn-success me-2">Add to Cart</a> -->
                  <!-- <a href="buy-now.php?product_id=<?= $row['id'] ?>" class="btn btn-primary">Buy Now</a> -->
                   <a href="add_to_cart.php?id=<?= $row['id'] ?>" class="btn btn-success">Add to Cart</a>
                  <a href="checkout.php?product_id=<?= $row['id'] ?>" class="btn btn-primary ms-2">Buy Now</a>
                </div>
              </div>
            </div>
          </div>
        <?php endwhile; ?>
      <?php else: ?>
        <p>No products found in this category.</p>
      <?php endif; ?>
    </div>
  </div>
</section>

<?php include 'includes/footer.php'; ?>
