<?php
session_start();
include('db.php'); // $conn should be your MySQLi connection

// Redirect if not logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

// Fetch cart items from database
$user_id = $_SESSION['user_id'];
$stmt = $conn->prepare("
    SELECT c.id AS cart_id, p.id AS product_id, p.product_name AS name, p.price, c.quantity
    FROM carts c
    JOIN products p ON c.product_id = p.id
    WHERE c.user_id = ?
");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$items = $result->fetch_all(MYSQLI_ASSOC);

include('includes/header.php');
?>

<section class="py-5">
  <div class="container">
    <h2 class="text-success mb-4">Checkout</h2>

    <?php if (count($items) > 0): ?>
      <div class="row">
        <!-- Order Summary -->
        <div class="col-md-6">
          <h4>Order Summary</h4>
          <table class="table table-bordered">
            <thead>
              <tr>
                <th>Product</th>
                <th>Qty</th>
                <th>Price (₹)</th>
                <th>Total (₹)</th>
              </tr>
            </thead>
            <tbody>
              <?php
              $grand_total = 0;
              foreach ($items as $item):
                  $subtotal = $item['quantity'] * $item['price'];
                  $grand_total += $subtotal;
              ?>
              <tr>
                <td><?= htmlspecialchars($item['name']) ?></td>
                <td><?= $item['quantity'] ?></td>
                <td>₹<?= number_format($item['price'], 2) ?></td>
                <td>₹<?= number_format($subtotal, 2) ?></td>
              </tr>
              <?php endforeach; ?>
              <tr>
                <td colspan="3" class="text-end"><strong>Grand Total:</strong></td>
                <td><strong>₹<?= number_format($grand_total, 2) ?></strong></td>
              </tr>
            </tbody>
          </table>
        </div>

        <!-- Shipping & Payment Form -->
        <div class="col-md-6">
          <h4>Shipping Details</h4>
          <form method="post" action="place_order.php">
            <div class="mb-3">
              <label class="form-label">Full Name</label>
              <input type="text" name="name" class="form-control" required>
            </div>

            <div class="mb-3">
              <label class="form-label">Phone</label>
              <input type="text" name="phone" class="form-control" required>
            </div>

            <div class="mb-3">
              <label class="form-label">Email</label>
              <input type="email" name="email" class="form-control">
            </div>

            <div class="mb-3">
              <label class="form-label">Address Line 1</label>
              <input type="text" name="address_line1" class="form-control" required>
            </div>

            <div class="mb-3">
              <label class="form-label">Address Line 2</label>
              <input type="text" name="address_line2" class="form-control">
            </div>

            <div class="mb-3">
              <label class="form-label">City / District</label>
              <input type="text" name="city" class="form-control" required>
            </div>

            <div class="mb-3">
              <label class="form-label">State</label>
              <input type="text" name="state" class="form-control" required>
            </div>

            <div class="mb-3">
              <label class="form-label">Pincode</label>
              <input type="text" name="pincode" class="form-control" required>
            </div>

            <div class="mb-3">
              <label class="form-label">Country</label>
              <input type="text" name="country" class="form-control" value="India" readonly>
            </div>

            <div class="mb-3">
              <label class="form-label">Delivery Instructions</label>
              <textarea name="instructions" class="form-control" rows="2"></textarea>
            </div>

            <div class="mb-3">
              <label class="form-label">Payment Method</label>
              <select name="payment_method" class="form-select" required>
                <option value="COD">Cash on Delivery</option>
                <option value="UPI">UPI</option>
                <option value="Card">Credit/Debit Card</option>
              </select>
            </div>

            <input type="hidden" name="total_amount" value="<?= $grand_total ?>">
            <button type="submit" class="btn btn-success w-100">Place Order</button>
          </form>
        </div>
      </div>

    <?php else: ?>
      <div class="alert alert-warning">
        🛒 Your cart is empty. <a href="products.php">Shop now</a>.
      </div>
    <?php endif; ?>

  </div>
</section>

<?php include('includes/footer.php'); ?>
