<?php
// Only load once to avoid duplicates
if (!defined('FOOTER_ASSETS_INCLUDED')) {
  define('FOOTER_ASSETS_INCLUDED', true);
  echo '
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

  <!-- Font Awesome -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">

  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">

  <style>
    body {
      font-family: "Poppins", sans-serif;
    }
    footer a:hover {
      opacity: 0.9;
      text-decoration: underline;
    }
  </style>
  ';
}
?>


<!-- CTA Banner Above Footer -->
<section style="background: #28a745 url('https://www.transparenttextures.com/patterns/leaf.png') repeat; color: white; padding: 50px 20px; border-radius: 0 0 80px 0;">
  <div class="container d-lg-flex justify-content-between align-items-center text-center text-lg-start">
    <div>
      <h2 class="fw-bold mb-2">Ready to Get Free Consultations</h2>
      <p class="mb-0">Any kind Of IT Solutions?</p>
    </div>
    <div class="mt-4 mt-lg-0">
      <a href="#" class="btn btn-light btn-lg me-3 shadow rounded-3">GET A QUOTE <i class="fas fa-arrow-right ms-1"></i></a>
      <a href="#" class="btn btn-outline-light btn-lg rounded-3">READ MORE <i class="fas fa-arrow-right ms-1"></i></a>
    </div>
  </div>
</section>

<!-- Main Footer -->
<footer style="background: url('https://images.unsplash.com/photo-1748333855583-648cca9031e9?q=80&w=2072&auto=format&fit=crop&ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D;">
  <div class="container py-5">
    <div class="row text-center text-md-start gy-4">

      <!-- About Us -->
      <div class="col-md-3">
        <h5 class="fw-bold text-white mb-3">About us</h5>
        <p class="small text-light">Garden Services provides full & comprehensive services in irrigation, landscape, maintenance and professional tree care.</p>
        <div class="mt-3">
          <a href="#" class="text-white me-3 fs-5"><i class="fab fa-facebook-f"></i></a>
          <a href="#" class="text-white me-3 fs-5"><i class="fab fa-twitter"></i></a>
          <a href="#" class="text-white me-3 fs-5"><i class="fab fa-instagram"></i></a>
          <a href="#" class="text-white fs-5"><i class="fab fa-pinterest-p"></i></a>
        </div>
      </div>

      <!-- Quick Links -->
      <div class="col-md-3">
        <h5 class="fw-bold text-white mb-3">Quick Links</h5>
        <ul class="list-unstyled small">
          <li><a href="/globalgardenia/index.php" class="text-white text-decoration-none d-block mb-2">Home</a></li>
          <li><a href="/globalgardenia/about.php" class="text-white text-decoration-none d-block mb-2">About</a></li>
          <li><a href="/globalgardenia/testimonials.php" class="text-white text-decoration-none d-block mb-2">Testimonials</a></li>
          <li><a href="#" class="text-white text-decoration-none d-block mb-2">Blog</a></li>
          <li><a href="/globalgardenia/contact.php" class="text-white text-decoration-none d-block">Contact</a></li>
        </ul>
      </div>

      <!-- Contact Info -->
        <div class="col-md-3">
        <h5 class="fw-bold text-light mb-3">Contact Info</h5>
        <p class="small text-light mb-2"><i class="fas fa-map-marker-alt me-2"></i>Delhi, India</p>
        <p class="small text-light mb-2"><i class="fas fa-envelope me-2"></i>garda@mail.com</p>
        <p class="small text-light mb-2"><i class="fas fa-phone me-2"></i>+880 123 456 789</p>
        <p class="small text-light"><i class="fas fa-clock me-2"></i>Mon–Fri: 08.00 – 16.00</p>
        </div>


      <!-- Solutions -->
      <div class="col-md-3">
        <h5 class="fw-bold text-white mb-3">Our Location</h5>
        <div class="ratio ratio-4x3"> <!-- Maintains aspect ratio -->
          <iframe
            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3500.6849388608625!2d77.20207477495816!3d28.66915088241769!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x390cfd82be1196d1%3A0x12c129430f26d52a!2sGLOBAL%20SEEDS%20INDIA%20PRIVATE%20LIMITED!5e0!3m2!1sen!2sin!4v1750832565068!5m2!1sen!2sin" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade">
            width="100%" height="200" style="border:0;" allowfullscreen="" loading="lazy"
            referrerpolicy="no-referrer-when-downgrade"></iframe>
        </div>
      </div>


    <!-- Copyright -->
        <div class="text-center mt-4 pt-4 border-top border-light">
        <p class="small mb-0 text-light">&copy; <?= date('Y') ?> <strong>Garda</strong> — All rights reserved. Designed by <span class="text-success fw-semibold">CaseThemes</span>.</p>
        </div>
  </div>
</footer>

<!-- Scroll to Top Button -->
<a href="#" class="position-fixed bottom-0 end-0 m-4 bg-white text-success p-2 rounded-circle shadow" style="z-index:999;"><i class="fas fa-arrow-up"></i></a>