<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Product Gallery - Global Seeds</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background-color: #f8fdf8;
      font-family: Arial, sans-serif;
    }

    .gallery-heading {
      background-color: #0b6623;
      color: #fff;
      padding: 15px 0;
      text-align: center;
      font-size: 28px;
      font-weight: 600;
      margin-bottom: 30px;
    }

    .gallery-img {
      width: 100%;
      height: 220px;
      object-fit: cover;
      border-radius: 10px;
      border: 4px solid #fff;
      box-shadow: 0 4px 8px rgba(0, 100, 0, 0.1);
      transition: transform 0.3s ease;
    }

    .gallery-img:hover {
      transform: scale(1.05);
    }

    .gallery-container {
      padding-bottom: 50px;
    }
  </style>
</head>
<body>

<div class="container text-center mb-4">
  <div class="gallery-heading px-4 py-2 d-inline-block rounded">
    Product Gallery
  </div>
</div>

  <div class="container gallery-container">
    <div class="row g-4">
      <?php
        // ✅ Image URLs passed here
        $imageUrls = [
          "https://images.unsplash.com/photo-1708352547267-3a91b3ba0b1b?q=80&w=2070&auto=format&fit=crop&ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D",
          "https://images.unsplash.com/photo-1588106467949-d8aa78474694?q=80&w=2073&auto=format&fit=crop&ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D",
          "https://images.unsplash.com/photo-1649256282262-b0cbd6e420c6?q=80&w=2070&auto=format&fit=crop&ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D",
          "https://images.unsplash.com/photo-1699565769463-2d10b406db4e?q=80&w=1994&auto=format&fit=crop&ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D",
          "https://images.unsplash.com/photo-1614507991839-c6262af0d7b1?q=80&w=1974&auto=format&fit=crop&ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D",
          "https://images.unsplash.com/photo-1607214540429-c2b96c3ef533?q=80&w=2070&auto=format&fit=crop&ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D",
          "https://images.unsplash.com/photo-1634582872934-be411573f235?q=80&w=1974&auto=format&fit=crop&ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D",
          "https://images.unsplash.com/photo-1546810607-e48b53951d54?q=80&w=1964&auto=format&fit=crop&ixlib=rb-4.1.0&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D"
        ];

        foreach ($imageUrls as $url) {
          echo '
            <div class="col-6 col-md-3">
              <img src="' . $url . '" class="gallery-img" alt="Product Image">
            </div>
          ';
        }
      ?>
    </div>
  </div>

</body>
</html>
