<?php
// Always start session before output
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}

// include DB connection
include $_SERVER['DOCUMENT_ROOT'] . '/globalgardenia/db.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0"> 
  <title>Global Gardenia</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
  <style>
    body { font-family: 'Poppins', sans-serif; }
    .top-bar {
      background-color: #28a745;
      color: white;
      font-size: 14px;
      padding: 5px 0;
    }
    .navbar {
      background: #fff;
      box-shadow: 0 1px 10px rgba(0,0,0,0.1);
    }
    .navbar-nav .nav-link {
      font-weight: 500;
      color: #28a745 !important;
      margin: 0 10px;
    }
    .dropdown-menu {
      border-radius: 10px;
      box-shadow: 0 10px 25px rgba(0,0,0,0.1);
    }
    .dropdown-item:hover { background-color: #f8f9fa; }
    .dropdown:hover .dropdown-menu {
      display: block;
      margin-top: 0;
    }
  </style>
</head>
<body>

  <div class="top-bar text-center">
    Welcome to Global Gardenia! &nbsp;
    <i class="fab fa-facebook-f"></i>
    <i class="fab fa-twitter ms-2"></i>
    <i class="fab fa-linkedin-in ms-2"></i>
    <i class="fab fa-youtube ms-2"></i>
  </div>

  <nav class="navbar navbar-expand-lg">
    <div class="container">
      <a class="navbar-brand fw-bold text-success" href="/global-gardenia/index.php">
        <img src="https://cdn-icons-png.flaticon.com/512/2907/2907411.png" alt="logo" width="40">
        Global Gardenia
      </a>
      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
        <span class="navbar-toggler-icon"></span>
      </button>

      <div class="collapse navbar-collapse" id="navbarNav">
        <ul class="navbar-nav ms-auto">

          <li class="nav-item"><a href="index.php" class="nav-link">Home</a></li>

          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" id="pagesDropdown" role="button" data-bs-toggle="dropdown">Pages</a>
            <ul class="dropdown-menu" aria-labelledby="pagesDropdown">
              <li><a class="dropdown-item" href="about.php">About Us</a></li>
              <li><a class="dropdown-item" href="pricing.php">Our Pricing</a></li>
              <li><a class="dropdown-item" href="testimonials.php">Testimonials</a></li>
              <li><a class="dropdown-item" href="contact.php">Contact</a></li>
            </ul>
          </li>

          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" id="shopDropdown" role="button" data-bs-toggle="dropdown">Shop by Category</a>
            <ul class="dropdown-menu" aria-labelledby="shopDropdown">
              <?php
              $categories = $conn->query("SELECT * FROM product_categories ORDER BY category_name ASC");
              if ($categories):
                while ($cat = $categories->fetch_assoc()):
              ?>
                <li><a class="dropdown-item" href="category-product.php?slug=<?= urlencode($cat['slug']) ?>">
                  <?= htmlspecialchars($cat['category_name']) ?></a></li>
              <?php endwhile; endif; ?>
            </ul>
          </li>

          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" id="potsDropdown" role="button" data-bs-toggle="dropdown">Pots & Planters</a>
            <ul class="dropdown-menu" aria-labelledby="potsDropdown">
              <li><a class="dropdown-item" href="service1.php">Plastic Pots</a></li>
              <li><a class="dropdown-item" href="service2.php">Ceramic Pots</a></li>
              <li><a class="dropdown-item" href="service3.php">Metal Planter</a></li>
              <li><a class="dropdown-item" href="service3.php">Wooden Planter</a></li>
              <li><a class="dropdown-item" href="service3.php">3D Printed Pots</a></li>
              <li><a class="dropdown-item" href="service3.php">Hanging Planter</a></li>
              <li><a class="dropdown-item" href="service3.php">Plant Stands</a></li>
              <li><a class="dropdown-item" href="service3.php">Seedling Trays</a></li>
              <li><a class="dropdown-item" href="service3.php">Basket Planters</a></li>
            </ul>
          </li>

          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" id="plantcareDropdown" role="button" data-bs-toggle="dropdown">Plant Care</a>
            <ul class="dropdown-menu" aria-labelledby="plantcareDropdown">
              <li><a class="dropdown-item" href="service1.php">Potting Mix & Fertilizers</a></li>
              <li><a class="dropdown-item" href="service2.php">Garden Tools</a></li>
              <li><a class="dropdown-item" href="service3.php">Watering Tools and Accessories</a></li>
              <li><a class="dropdown-item" href="service3.php">Garden Decor and Accessories</a></li>
              <li><a class="dropdown-item" href="service3.php">Pest Control</a></li>
            </ul>
          </li>

          <li class="nav-item"><a class="nav-link" href="blog.php">Blog</a></li>

          <!-- 🔑 E-COMMERCE SECTION -->
          <li class="nav-item"><a href="cart.php" class="nav-link"><i class="fa fa-shopping-cart"></i> Cart</a></li>

          <?php if(isset($_SESSION['user_id'])): ?>
            <li class="nav-item"><a href="account.php" class="nav-link">My Account</a></li>
            <li class="nav-item"><a href="logout.php" class="nav-link">Logout</a></li>
          <?php else: ?>
            <li class="nav-item"><a href="login.php" class="nav-link">Login</a></li>
            <li class="nav-item"><a href="register.php" class="nav-link">Register</a></li>
          <?php endif; ?>

        </ul>
      </div>
    </div>
  </nav>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
